<?php

namespace App\Providers;

use Illuminate\Cache\RateLimiting\Limit;
use Illuminate\Foundation\Support\Providers\RouteServiceProvider as ServiceProvider;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\RateLimiter;
use Illuminate\Support\Facades\Route;

class RouteServiceProvider extends ServiceProvider
{
    /**
     * The path to your application's "home" route.
     *
     * Typically, users are redirected here after authentication.
     *
     * @var string
     */
    public const HOME = '/admin';

    /**
     * Define your route model bindings, pattern filters, and other route configuration.
     */
    public function boot(): void
    {
        RateLimiter::for('api', function (Request $request) {
            return Limit::perMinute(60)->by($request->user()?->id ?: $request->ip());
        });

        $this->routes(function () {
            Route::middleware('api')->prefix('api')->group(base_path('routes/api.php'));
            Route::middleware('web')->group(base_path('routes/web.php'));

            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/acl.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/admin.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/fortify.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/blog.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/page.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/menu.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/tools.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/notification.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/comment.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Admin')->group(base_path('routes/configuration.php'));
            Route::middleware('web')->namespace('App\Http\Controllers\Front')->group(base_path('routes/front.php'));
        });
    }
}
